/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.recipebook;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.recipebook.GuiRecipeBook;
import net.minecraft.client.gui.recipebook.IRecipeUpdateListener;
import net.minecraft.client.gui.recipebook.RecipeBookPage;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.api.mixin.stats.IRecipeBookMixin;
import noppes.npcs.client.gui.player.GuiNpcCarpentryBench;
import noppes.npcs.client.gui.recipebook.NpcGuiButtonRecipe;
import noppes.npcs.client.gui.recipebook.NpcGuiRecipeOverlay;
import noppes.npcs.util.Util;

@SideOnly(value=Side.CLIENT)
public class NpcRecipeBookPage
extends RecipeBookPage {
    private GuiButtonToggle backButton;
    private final List<NpcGuiButtonRecipe> buttons = new ArrayList<NpcGuiButtonRecipe>(20);
    private int currentPage;
    private GuiButtonToggle forwardButton;
    private NpcGuiButtonRecipe hoveredButton;
    private IRecipe lastClickedRecipe;
    private RecipeList lastClickedRecipeList;
    private final List<IRecipeUpdateListener> listeners = new ArrayList<IRecipeUpdateListener>();
    private Minecraft minecraft;
    private final NpcGuiRecipeOverlay overlay = new NpcGuiRecipeOverlay();
    private RecipeBook recipeBook;
    private List<RecipeList> recipeLists;
    private int totalPages;

    public NpcRecipeBookPage() {
        for (int i = 0; i < 20; ++i) {
            this.buttons.add(new NpcGuiButtonRecipe());
        }
    }

    public void func_193732_a(@Nonnull GuiRecipeBook guiBook) {
        this.listeners.remove(guiBook);
        this.listeners.add((IRecipeUpdateListener)guiBook);
    }

    @Nullable
    public IRecipe func_194193_a() {
        return this.lastClickedRecipe;
    }

    @Nullable
    public RecipeList func_194199_b() {
        return this.lastClickedRecipeList;
    }

    public void func_194194_a(Minecraft mc, int u, int v) {
        boolean isGlobal = !(mc.field_71462_r instanceof GuiNpcCarpentryBench);
        this.overlay.setGlobal(isGlobal);
        this.minecraft = mc;
        this.recipeBook = ((IRecipeBookMixin)mc.field_71439_g.func_192035_E()).npcs$copyToNew(isGlobal, (EntityPlayer)mc.field_71439_g);
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).func_191770_c(u + 11 + 25 * (i % 5), v + 31 + 25 * (i / 5));
        }
        ResourceLocation texture = Util.RECIPE_BOOK;
        this.forwardButton = new GuiButtonToggle(0, u + 93, v + 137, 12, 17, false);
        this.forwardButton.func_191751_a(1, 208, 13, 18, texture);
        this.backButton = new GuiButtonToggle(0, u + 38, v + 137, 12, 17, true);
        this.backButton.func_191751_a(1, 208, 13, 18, texture);
    }

    public boolean func_194196_a(int mouseX, int mouseY, int mouseButton, int x, int y, int width, int height) {
        this.lastClickedRecipe = null;
        this.lastClickedRecipeList = null;
        if (this.overlay.func_191839_a()) {
            if (this.overlay.func_193968_a(mouseX, mouseY, mouseButton)) {
                this.lastClickedRecipe = this.overlay.func_193967_b();
                this.lastClickedRecipeList = this.overlay.func_193971_a();
            } else {
                this.overlay.func_192999_a(false);
            }
            return true;
        }
        if (this.forwardButton.func_146116_c(this.minecraft, mouseX, mouseY) && mouseButton == 0) {
            this.forwardButton.func_146113_a(this.minecraft.func_147118_V());
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.func_146116_c(this.minecraft, mouseX, mouseY) && mouseButton == 0) {
            this.backButton.func_146113_a(this.minecraft.func_147118_V());
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        for (NpcGuiButtonRecipe button : this.buttons) {
            if (!button.func_146116_c(this.minecraft, mouseX, mouseY)) continue;
            button.func_146113_a(this.minecraft.func_147118_V());
            if (mouseButton == 0) {
                this.lastClickedRecipe = button.func_193760_e();
                this.lastClickedRecipeList = button.func_191771_c();
            } else if (!this.overlay.func_191839_a() && !button.func_193929_d()) {
                this.overlay.func_191845_a(this.minecraft, button.func_191771_c(), button.field_146128_h, button.field_146129_i, x + width / 2, y + 13 + height / 2, button.func_146117_b(), this.recipeBook);
            }
            return true;
        }
        return false;
    }

    public void func_194195_a(@Nonnull List<IRecipe> recipeList) {
        for (IRecipeUpdateListener irecipeupdatelistener : this.listeners) {
            irecipeupdatelistener.func_193001_a(recipeList);
        }
    }

    public void func_194191_a(int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.totalPages > 1) {
            String s = this.currentPage + 1 + "/" + this.totalPages;
            int i = this.minecraft.field_71466_p.func_78256_a(s);
            this.minecraft.field_71466_p.func_78276_b(s, x - i / 2 + 73, y + 141, -1);
        }
        this.hoveredButton = null;
        for (NpcGuiButtonRecipe guibuttonrecipe : this.buttons) {
            guibuttonrecipe.func_191745_a(this.minecraft, mouseX, mouseY, partialTicks);
            if (!guibuttonrecipe.field_146125_m || !guibuttonrecipe.func_146115_a()) continue;
            this.hoveredButton = guibuttonrecipe;
        }
        this.backButton.func_191745_a(this.minecraft, mouseX, mouseY, partialTicks);
        this.forwardButton.func_191745_a(this.minecraft, mouseX, mouseY, partialTicks);
        this.overlay.func_191842_a(mouseX, mouseY, partialTicks);
    }

    public void func_193721_a(int mouseButton, int p_193721_2_) {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.func_71410_x();
        }
        if (this.minecraft.field_71462_r != null && this.hoveredButton != null && this.overlay != null && !this.overlay.func_191839_a()) {
            this.minecraft.field_71462_r.func_146283_a(this.hoveredButton.func_191772_a(this.minecraft.field_71462_r), mouseButton, p_193721_2_);
        }
    }

    private void updateArrowButtons() {
        this.forwardButton.field_146125_m = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.field_146125_m = this.totalPages > 1 && this.currentPage > 0;
    }

    private void updateButtonsForPage() {
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.buttons.size(); ++j) {
            NpcGuiButtonRecipe guibuttonrecipe = this.buttons.get(j);
            if (i + j < this.recipeLists.size()) {
                RecipeList recipelist = this.recipeLists.get(i + j);
                guibuttonrecipe.init(recipelist, this, this.recipeBook);
                guibuttonrecipe.field_146125_m = true;
                continue;
            }
            guibuttonrecipe.field_146125_m = false;
        }
        this.updateArrowButtons();
    }

    public void func_194192_a(List<RecipeList> p_194192_1_, boolean p_194192_2_) {
        this.recipeLists = p_194192_1_;
        this.totalPages = (int)Math.ceil((double)p_194192_1_.size() / 20.0);
        if (this.totalPages <= this.currentPage || p_194192_2_) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }
}

